# Trader Nerf Mod v2.2

**A comprehensive trader rebalance mod that makes 7 Days to Die more challenging by nerfing overpowered trader mechanics.**

## 🎯 What This Mod Does

- **Prices 6.5x higher** - Forces reliance on looting and crafting instead of buying everything
- **Stock reduced by 80%** - Limited trader inventory makes items scarce
- **Quest rewards nerfed** - Only 2 reward choices instead of 5 (reduces optimization)
- **No XP from selling** - Prevents vehicle salvage → selling → rapid leveling exploit
- **Daring Adventurer perk nerfed** - Delays endgame gear access by 15-20 days
- **Essential items excluded** - Water Filter stays at vanilla 7,500 dukes (not 15,000)

## 📦 Installation

1. **Download** and extract to your `Mods` folder
2. **Restart** your 7 Days to Die game
3. **Server owners**: Install on server only (affects all players)

## ⚙️ Configuration

### Quick Settings (Config/TraderNerfSettings.xml)
- **BuyMarkup**: `20` = current pricing (change to `6` for mild, `30` for brutal)
- **Stock multipliers**: `0.2` = 20% of vanilla stock (increase for more items)
- **NerfDaringAdventurer**: `true` = perk nerfed (set `false` for vanilla)

### Item Exclusions (Config/items.xml)
- **Currently excluded**: Water Filter (7,500 dukes instead of 15,000)
- **Add more items**: Use the template sections for Medical, Tools, Food categories
- **Change markup**: Uncomment the matching preset block when changing BuyMarkup

### Presets Available
- **Mild Nerf**: 6x prices, 60% stock
- **Default**: 20x prices, 20% stock (active)
- **Brutal**: 30x prices, 10% stock

## 🔧 Common Customizations

**Want different pricing?**
1. Change `BuyMarkup` in `TraderNerfSettings.xml`
2. Update matching preset in `items.xml` for exclusions

**Want more excluded items?**
1. Find item name in game files
2. Calculate: `(ItemValue × 10) ÷ YourMarkup = RequiredValue`
3. Add to appropriate section in `items.xml`

**Want XP from selling?**
- Set `RemoveSellingXP` to `false` in `TraderNerfSettings.xml`

## 📖 Need More Details?
See `README_DETAILED.md` for comprehensive documentation, compatibility info, and advanced configuration.

---
**Version 2.2** | Compatible with modded items | Server-side only