# Asylum Advanced Workbench Custom Unity Model

## Required File
Place your custom Unity asset bundle here as: `AsylumWorkbench.unity3d`

## Unity Asset Bundle Requirements

Your Unity asset bundle should contain:
- **Prefab Name**: `AsylumAdvancedWorkbenchPrefab` (this matches the reference in blocks.xml)
- **Model Type**: Static workstation/industrial equipment model
- **Recommended Scale**: Similar to vanilla workbench (2x2x1 footprint)

## Unity Setup Guidelines

1. **Model Requirements**:
   - Should be a static model (no animations required for workstations)
   - Appropriate scale for a 2x2x1 workstation
   - Include proper materials/textures
   - **Asylum Theme Styling**: Dark, industrial colors with asylum aesthetic
   - Consider titanium/metallic materials to match the forged titanium requirement
   - Optional: Subtle purple/dark red accents to match asylum color scheme

2. **Prefab Setup**:
   - Name the main prefab `AsylumAdvancedWorkbenchPrefab`
   - Ensure proper pivot point (usually at base/center)
   - Add appropriate colliders if needed
   - Test scale in Unity before building asset bundle
   - Consider adding subtle particle effects or glowing elements

3. **Asset Bundle Build**:
   - Build for Windows Standalone platform
   - Name the asset bundle `AsylumWorkbench.unity3d`
   - Place in this Resources folder

## Current Configuration

The mod is configured to load:
```xml
<property name="Model" value="#@modfolder:Resources/AsylumWorkbench.unity3d?AsylumAdvancedWorkbenchPrefab"/>
```

This means:
- **File**: `AsylumWorkbench.unity3d` in the Resources folder
- **Prefab**: `AsylumAdvancedWorkbenchPrefab` inside the asset bundle
- **Loading**: Uses @modfolder reference for mod-relative path

## Fallback

If no custom model is provided, you can temporarily revert to vanilla by changing blocks.xml back to:
```xml
<property name="Model" value="@:Entities/Crafting/woodWorkBenchPrefab.prefab"/>
```

## Design Suggestions

For the Asylum Advanced Workbench model:
- **Base**: Enhanced version of vanilla workbench with more industrial/technological elements
- **Materials**: Dark metals, titanium-like surfaces, subtle asylum branding
- **Details**: Additional mechanical parts, advanced control panels, titanium reinforcements
- **Atmosphere**: Should convey advanced technology with ominous asylum undertones
- **Size**: Maintain 2x2x1 footprint but can be taller/more detailed than vanilla

## Integration with Asylum Ecosystem

This workbench should visually represent:
- The use of premium forged titanium materials
- Advanced asylum technology
- 33% crafting speed improvement through visible automation
- Connection to the broader asylum mod aesthetic

## Additional Required Files

### Asylum Ammo Press Model
Copy `AsylumAmmoPress.unity3d` from the original AsylumAmmoPress mod to this Resources folder.

**Required File**: `AsylumAmmoPress.unity3d`
- **Source**: `Mods/AsylumAmmoPress/Resources/AsylumAmmoPress.unity3d`
- **Destination**: `Mods/AsylumWorkstations/Resources/AsylumAmmoPress.unity3d`
- **Contains**: `AmmoMakingMachine` prefab for the ammo press model
