using HarmonyLib;
using SCore.Features.ItemDegradation.Utils;

namespace SCore.Features.ItemDegradation.Harmony.Workstations
{
    // Patching UpdateVisible instead of HandleModChanged to avoid a v2.6 compatibility issue:
    // HandleModChanged's IL references the private field by its old name ("modSlots"), which was
    // renamed to "modSlotsInternal" in v2.6. MonoMod's DMD uses name-based field resolution and
    // throws MissingFieldException when it tries to compile a dynamic copy of HandleModChanged.
    // UpdateVisible calls HandleModChanged internally and does not directly reference that field,
    // so its DMD compiles cleanly.
    [HarmonyPatch(typeof(TileEntityCollector))]
    [HarmonyPatch("UpdateVisible")]
    public class TileEntityDewCollectorHandleModChanged
    {
        public static void Postfix(TileEntityCollector __instance)
        {
            var modSlots = __instance.ModSlots;
            if (modSlots == null) return;
            var blockDewCollector = (BlockCollector)__instance.blockValue.Block;
            for (int i = 0; i < modSlots.Length; i++)
            {
                var mod = modSlots[i];
                if (mod.IsEmpty()) continue;

                if (!ItemDegradationHelpers.CanDegrade(mod.itemValue)) continue;

                // Reset the conversions based on if each type is degraded.
                OnSelfItemDegrade.CheckForDegradation(mod);

                // If it's not degraded, don't reset its items.
                if (!ItemDegradationHelpers.IsDegraded(mod.itemValue)) continue;

                switch (blockDewCollector.ModTypes[i])
                {
                    case BlockCollector.ModEffectTypes.Type:
                        __instance.IsModdedConvertItem = false;
                        break;
                    case BlockCollector.ModEffectTypes.Speed:
                        __instance.CurrentConvertSpeed = 1f;
                        break;
                    case BlockCollector.ModEffectTypes.Count:
                        __instance.CurrentConvertCount = 1;
                        break;
                }
            }
        }
    }
}